	'
	' Animation of cats
	' by Oscar Toledo G.
	' Example for CVBasic
	'
	' Creation date: Apr/27/2025. For Sega Master System.
	'

	DIM x(8),y(8),f(8)

	FOR c = 0 TO 7
		x(c) = RANDOM(176) + 32
		y(c) = RANDOM(112) + 32
		IF c AND 1 THEN f(c) = 4 ELSE f(c) = 0
	NEXT c

	DEFINE SPRITE 0,16,cat_sprites

main_loop:
	WAIT
	FOR c = 0 TO 7
		SPRITE c * 2 + 0, y(c), x(c), f(c) * 4
		SPRITE c * 2 + 1, y(c), x(c) + 8, f(c) * 4 + 2
	NEXT c

	IF (FRAME AND 7) = 0 THEN
		FOR c = 0 TO 7
			f(c) = f(c) + 1
			IF f(c) = 4 THEN f(c) = 0
			IF f(c) = 8 THEN f(c) = 4
		NEXT c
	END IF

	GOTO main_loop

	' TMSColor 3.0 Apr/27/2025
	' Command: ../tmscolor/tmscolor -sms -sb -b -i cats_sprites.bmp cats_sprites_sms.bas cat_sprites 
	' Created: Sun Apr 27 13:34:22 2025

	'
	' Sample code:
	' DEFINE SPRITE 0,16,cat_sprites
	'
cat_sprites:
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "EE0000EE"
	BITMAP "EE00000E"
	BITMAP "EE00000F"

	BITMAP "EE00000E"
	BITMAP "0EE00000"
	BITMAP "0EE0EEEE"
	BITMAP "00EEEEEE"
	BITMAP "00EEEEEE"
	BITMAP "0EEEEEEE"
	BITMAP "0E555EE0"
	BITMAP "EEEEE0E0"


	BITMAP "00000000"
	BITMAP "E000E000"
	BITMAP "E500E000"
	BITMAP "EE5EE000"
	BITMAP "EE555000"
	BITMAP "52252EE0"
	BITMAP "52252E00"
	BITMAP "FFE5EFFF"

	BITMAP "5EEEEE00"
	BITMAP "FFEEFFF0"
	BITMAP "E5EEE000"
	BITMAP "EEE0E500"
	BITMAP "EEE0E500"
	BITMAP "05E0E500"
	BITMAP "05E0E500"
	BITMAP "0EE0EE00"


	BITMAP "00000000"
	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "EE000EE5"
	BITMAP "EE0000E5"
	BITMAP "EE0000FF"

	BITMAP "EE0000E5"
	BITMAP "0EE0000F"
	BITMAP "0EE0EEEE"
	BITMAP "00EEEEEE"
	BITMAP "00EEEEEE"
	BITMAP "0EEEEEEE"
	BITMAP "0E555EE0"
	BITMAP "EEEEE0E0"


	BITMAP "00000000"
	BITMAP "000E0000"
	BITMAP "500E0000"
	BITMAP "E5EE0000"
	BITMAP "E5550000"
	BITMAP "2522EE00"
	BITMAP "2522E000"
	BITMAP "FE5EFFF0"

	BITMAP "EEEEE000"
	BITMAP "FEEFFF00"
	BITMAP "5EEE0000"
	BITMAP "EEE0E500"
	BITMAP "EEE0E500"
	BITMAP "05E0E500"
	BITMAP "05E0E500"
	BITMAP "0EE0EE00"


	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "00000EE5"
	BITMAP "EE0000E5"
	BITMAP "EE0000FF"
	BITMAP "EE0000E5"

	BITMAP "EE00000F"
	BITMAP "0EE00EEE"
	BITMAP "0EE0EEEE"
	BITMAP "00EEEEEE"
	BITMAP "00EEEEEE"
	BITMAP "0EEEEEEE"
	BITMAP "0E555EE0"
	BITMAP "EEEEE0E0"


	BITMAP "00000000"
	BITMAP "5000E000"
	BITMAP "E5EEE000"
	BITMAP "E5EE0000"
	BITMAP "2555EE00"
	BITMAP "2522E000"
	BITMAP "FE22FFF0"
	BITMAP "EEEEE000"

	BITMAP "FEEFFF00"
	BITMAP "5EEE0000"
	BITMAP "5EEE0000"
	BITMAP "EEE0E500"
	BITMAP "EEE0E500"
	BITMAP "05E0E500"
	BITMAP "05E0E500"
	BITMAP "0EE0EE00"


	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "0000000E"
	BITMAP "EE000EE5"
	BITMAP "EE0000E5"
	BITMAP "EE0000E5"

	BITMAP "EE0000FF"
	BITMAP "0EE0000E"
	BITMAP "0EE0EEEF"
	BITMAP "00EEEEEE"
	BITMAP "00EEEEEE"
	BITMAP "0EEEEEEE"
	BITMAP "0E555EE0"
	BITMAP "EEEEE0E0"


	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "000E0000"
	BITMAP "55EE0000"
	BITMAP "E5550000"
	BITMAP "5555EE00"
	BITMAP "2522E000"
	BITMAP "2E22E000"

	BITMAP "EEEEFFF0"
	BITMAP "EEEEE000"
	BITMAP "FEEFFF00"
	BITMAP "EEE0E500"
	BITMAP "EEE0E500"
	BITMAP "05E0E500"
	BITMAP "05E0E500"
	BITMAP "0EE0EE00"


	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00008000"
	BITMAP "00008855"
	BITMAP "00005558"
	BITMAP "00885555"
	BITMAP "00082252"
	BITMAP "00082282"

	BITMAP "0FFF8888"
	BITMAP "00088888"
	BITMAP "00FFF88F"
	BITMAP "00580888"
	BITMAP "00580888"
	BITMAP "00580850"
	BITMAP "00580850"
	BITMAP "00880880"


	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "58800088"
	BITMAP "58000088"
	BITMAP "58000088"

	BITMAP "FF000088"
	BITMAP "80000880"
	BITMAP "F8880880"
	BITMAP "88888800"
	BITMAP "88888800"
	BITMAP "88888880"
	BITMAP "08855580"
	BITMAP "08088888"


	BITMAP "00000000"
	BITMAP "00080005"
	BITMAP "00088858"
	BITMAP "00008858"
	BITMAP "00885552"
	BITMAP "00082252"
	BITMAP "0FFF228F"
	BITMAP "00088888"

	BITMAP "00FFF88F"
	BITMAP "00008885"
	BITMAP "00008885"
	BITMAP "00580888"
	BITMAP "00580888"
	BITMAP "00580850"
	BITMAP "00580850"
	BITMAP "00880880"


	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "58800000"
	BITMAP "58000088"
	BITMAP "FF000088"
	BITMAP "58000088"

	BITMAP "F0000088"
	BITMAP "88800880"
	BITMAP "88880880"
	BITMAP "88888800"
	BITMAP "88888800"
	BITMAP "88888880"
	BITMAP "08855580"
	BITMAP "08088888"


	BITMAP "00000000"
	BITMAP "00008000"
	BITMAP "00008005"
	BITMAP "00008858"
	BITMAP "00005558"
	BITMAP "00882252"
	BITMAP "00082252"
	BITMAP "0FFF858F"

	BITMAP "00088888"
	BITMAP "00FFF88F"
	BITMAP "00008885"
	BITMAP "00580888"
	BITMAP "00580888"
	BITMAP "00580850"
	BITMAP "00580850"
	BITMAP "00880880"


	BITMAP "00000000"
	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "80000000"
	BITMAP "58800088"
	BITMAP "58000088"
	BITMAP "FF000088"

	BITMAP "58000088"
	BITMAP "F0000880"
	BITMAP "88880880"
	BITMAP "88888800"
	BITMAP "88888800"
	BITMAP "88888880"
	BITMAP "08855580"
	BITMAP "08088888"


	BITMAP "00000000"
	BITMAP "00080008"
	BITMAP "00080058"
	BITMAP "00088588"
	BITMAP "00055588"
	BITMAP "08825225"
	BITMAP "00825225"
	BITMAP "FFF858FF"

	BITMAP "00888885"
	BITMAP "0FFF88FF"
	BITMAP "00088858"
	BITMAP "00580888"
	BITMAP "00580888"
	BITMAP "00580850"
	BITMAP "00580850"
	BITMAP "00880880"


	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "88000088"
	BITMAP "80000088"
	BITMAP "F0000088"

	BITMAP "80000088"
	BITMAP "00000880"
	BITMAP "88880880"
	BITMAP "88888800"
	BITMAP "88888800"
	BITMAP "88888880"
	BITMAP "08855580"
	BITMAP "08088888"


